<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

class CategoriesFrameworkModel extends AngieFrameworkModel
{
    public function __construct(CategoriesFramework $parent)
    {
        parent::__construct($parent);

        $this->addModel(
            DB::createTable('categories')->addColumns(
                [
                    new DBIdColumn(),
                    new DBTypeColumn('Category'),
                    new DBParentColumn(),
                    new DBNameColumn(100),
                    new DBCreatedOnByColumn(),
                    new DBUpdatedOnColumn(),
                ]
            )->addIndices(
                [
                    DBIndex::create('name', DBIndex::UNIQUE, ['parent_type', 'parent_id', 'type', 'name']),
                ]
            )
        )
            ->setTypeFromField('type')
            ->setOrderBy('name')
            ->setObjectIsAbstract(true)
            ->addModelTrait(null, 'IResetInitialSettingsTimestamp');
    }
}
