<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

return DB::createTable('jobs_queue')->addColumns(
    [
        (new DBIdColumn())
            ->setSize(DBColumn::BIG),
        new DBTypeColumn(),
        DBStringColumn::create('channel', DBStringColumn::MAX_LENGTH, 'main'),
        DBIntegerColumn::create('batch_id', 10)->setUnsigned(true),
        DBIntegerColumn::create('instance_id', 10, 0)->setUnsigned(true),
        DBIntegerColumn::create('priority')->setUnsigned(true),
        (new DBTextColumn('data'))
            ->setSize(DBTextColumn::BIG),
        new DBDateTimeColumn('available_at'),
        DBStringColumn::create('reservation_key', 40),
        new DBDateTimeColumn('reserved_at'),
        DBIntegerColumn::create('attempts', DBColumn::SMALL)->setUnsigned(true),
        DBIntegerColumn::create('process_id', 10, 0)->setUnsigned(true),
    ]
)->addIndices(
    [
        DBIndex::create('instance_id'),
        DBIndex::create('batch_id'),
        DBIndex::create('channel'),
        DBIndex::create('reservation_key', DBIndex::UNIQUE),
        DBIndex::create('priority'),
        DBIndex::create('reserved_at'),
    ]
);
