<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

return DB::createTable('jobs_queue_failed')->addColumns(
    [
        (new DBIdColumn())
            ->setSize(DBColumn::BIG),
        new DBTypeColumn(),
        DBStringColumn::create('channel', DBStringColumn::MAX_LENGTH, 'main'),
        DBIntegerColumn::create('batch_id', 10)->setUnsigned(true),
        (new DBTextColumn('data'))
            ->setSize(DBTextColumn::BIG),
        new DBDateTimeColumn('failed_at'),
        DBStringColumn::create('reason', DBStringColumn::MAX_LENGTH, ''),
    ]
)->addIndices(
    [
        DBIndex::create('channel'),
        DBIndex::create('batch_id'),
        DBIndex::create('failed_at'),
    ]
);
