<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

use ActiveCollab\Module\System\Model\FeaturePointer\ChristmasDiscountFeaturePointer;

class MigrateCreateChristmasDiscountFeaturePointer extends AngieModelMigration
{
    public function up()
    {
        if (!$this->checkIfFeaturePointerAlreadyExist()) {
            $this->insertFeaturePointer(ChristmasDiscountFeaturePointer::class);
        }
    }

    private function insertFeaturePointer($type)
    {
        $this->execute(
            'INSERT INTO feature_pointers (type, parent_id, created_on) VALUES (?, ?, ?)',
            $type,
            null,
            new DateTimeValue()
        );
    }

    private function checkIfFeaturePointerAlreadyExist(): bool {
        $result = $this->executeFirstCell('SELECT id FROM feature_pointers WHERE type = ?', ChristmasDiscountFeaturePointer::class);

        return $result ? true : false;
    }
}
