<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

use ActiveCollab\Module\System\Model\FeaturePointer\ChatFeaturePointer;
use ActiveCollab\Module\System\Model\FeaturePointer\LiveSupportFeaturePointer;

class MigrateFixChatFeaturePointersOrder extends AngieModelMigration
{
    public function up()
    {
        $chat_pointer_id = $this->executeFirstCell(
            'SELECT id FROM feature_pointers WHERE type = ?',
            ChatFeaturePointer::class
        );
        $live_support_pointer_id = $this->executeFirstCell(
            'SELECT id FROM feature_pointers WHERE type = ?',
            LiveSupportFeaturePointer::class
        );

        if ($chat_pointer_id && $live_support_pointer_id) {
            // clear dismissals
            $this->execute(
                'DELETE FROM feature_pointer_dismissals WHERE feature_pointer_id IN (?)',
                [$chat_pointer_id, $live_support_pointer_id],
            );

            $this->execute(
                'UPDATE feature_pointers SET parent_id = ? WHERE id = ?',
                $chat_pointer_id,
                $live_support_pointer_id
            );
        }
    }
}
