<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

/*
 * on_note_updated event handler.
 *
 * @package ActiveCollab.modules.notes
 * @subpackage handlers
 */

use ActiveCollab\Module\System\Utils\NotificationRecipientsCleaner\NotificationRecipientsCleanerInterface;

/**
 * Handle on_note_updated event.
 */
function notes_handle_on_note_updated(Note $note, array $attributes)
{
    if (array_key_exists('moved_to_project', $attributes)) {
        AngieApplication::getContainer()->get(NotificationRecipientsCleanerInterface::class)->clean($note);
    }

    Webhooks::dispatch($note, 'NoteUpdated');
}
