<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

namespace ActiveCollab\Module\System\Model\Conversation;

use ConversationUser;
use Message;
use ModelCollection;
use User;

interface ConversationInterface
{
    const CONVERSATION_TYPE_CUSTOM = 'custom';

    public function createMessage(User $user, string $body): Message;

    public function getMessages(User $user): ModelCollection;

    public function newMessagesSince(User $user): ConversationUser;
}
