<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

namespace ActiveCollab\Module\System\Model\Conversation;

use Client;
use DB;

class GeneralConversation extends SmartConversation
{
    public function getMemberIds(bool $use_cache = true): array
    {
        return DB::executeFirstColumn(
            'SELECT id FROM users WHERE is_archived = ? AND is_trashed = ? AND type <> ?', false, false, Client::class
        ) ?? [];
    }
}
