<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

namespace ActiveCollab\Module\System\Model\Conversation;

use IMembers;
use IUser;
use ValidationErrors;

class ParentObjectConversation extends SmartConversation
{
    public function getMemberIds(bool $use_cache = true): array
    {
        $parent = $this->getParent();

        return $parent && $parent instanceof IMembers ? $parent->getMemberIds($use_cache) : [];
    }

    public function validate(ValidationErrors &$errors)
    {
        if (!$this->validatePresenceOf('parent_type') || !$this->validatePresenceOf('parent_id')) {
            $errors->addError('Parent type fields are required.', 'parent_type');
        }

        if (!($this->getParent() instanceof IMembers)) {
            $errors->addError('Parent object must be instance of IMembers.', 'parent_type');
        }

        parent::validate($errors);
    }

    public function getTag(IUser $user, $use_cache = true)
    {
        $timestamp = $this->getUpdatedOn()->toMySQL();

        $parent = $this->getParent();
        $timestamp .= $parent ? $parent->getUpdatedOn()->toMySQL() : '';

        return '"' . implode(
                ',',
                [
                    APPLICATION_VERSION,
                    'object',
                    $this->getModelName(),
                    $this->getId(),
                    $user->getEmail(),
                    sha1(APPLICATION_UNIQUE_KEY . $timestamp),
                ]
            ) . '"';
    }
}
