<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Model\FeaturePointer;

use FeaturePointer;
use User;

class BudgetNotificationsFeaturePointer extends FeaturePointer
{
    public function shouldShow(User $user): bool
    {
        return $user->isFinancialManager() && parent::shouldShow($user);
    }

    public function getDescription(): string
    {
        return lang('Now you can set an alert to warn you when the budget is reaching its limit.');
    }
}
