<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

namespace ActiveCollab\Module\System\Model\FeaturePointer;

use AngieApplication;
use FeaturePointer;
use User;

class ChatFeaturePointer extends FeaturePointer
{
    public function shouldShow(User $user): bool
    {
        return AngieApplication::featureFlags()->isEnabled('chat')
            && !$user->isClient()
            && parent::shouldShow($user);
    }

    public function getDescription(): string
    {
        return lang('You can now chat with your team here!');
    }
}
