<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Model\FeaturePointer;

use AngieApplication;
use FeaturePointer;
use User;

class ChristmasDiscountFeaturePointer extends FeaturePointer
{
    public function shouldShow(User $user): bool
    {
        if (AngieApplication::isOnDemand()) {
            return parent::shouldShow($user) && $this->isAccountEligibleForFeaturePointer();
        }

        return false;
    }

    public function getDescription(): string
    {
        return AngieApplication::accountSettings()->getPricingModel()->isLegacy()
            ? lang('Switch to the Per Seat plan and get a 40-50% discount!')
            : lang('Get a 15% discount on your first purchase! Only on December 21.');
    }

    private function isAccountEligibleForFeaturePointer(): bool
    {
        return AngieApplication::isChristmasCampainActive() &&
            (AngieApplication::accountSettings()->getAccountStatus()->isTrial() || AngieApplication::accountSettings()->getPricingModel()->isLegacy());
    }
}
