<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Model\FeaturePointer;

use ActiveCollab\Module\OnDemand\Model\AddOn\AddOnInterface;
use ActiveCollab\Module\OnDemand\Models\Pricing\Plans2013\Plans2013PricingModelInterface;
use AngieApplication;
use FeaturePointer;
use User;

class InvoicesQRCodeFeaturePointer extends FeaturePointer
{
    public function shouldShow(User $user): bool
    {
        if (!$user->isFinancialManager()) {
            return false;
        }

        if (!parent::shouldShow($user)) {
            return false;
        }

        if (!AngieApplication::isOnDemand()) {
            return true;
        }

        if (AngieApplication::isOnDemand()) {
            $account_settings = AngieApplication::accountSettings();
            $paid_add_ons = $account_settings->getAddOns();
            $pricing_model = $account_settings->getPricingModel();

            if (!empty($paid_add_ons)) {
                foreach ($paid_add_ons as $paid_add_on) {
                    if (in_array($paid_add_on, [AddOnInterface::ADD_ON_GET_PAID_FULL, AddOnInterface::ADD_ON_GET_PAID])) {
                        return true;
                    }
                }
            }

            if ($pricing_model instanceof Plans2013PricingModelInterface) {
                return true;
            }
        }

        return false;
    }

    public function getDescription(): string
    {
        return lang('Now you can add a QR code to your invoices.');
    }
}
