<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Model\FeaturePointer;

use FeaturePointer;
use User;

class ProjectStopwatchFeaturePointer extends FeaturePointer
{
  public function shouldShow(User $user): bool
  {
      return !($user->isClient()) && parent::shouldShow($user);
  }

  public function getDescription(): string
  {
      return lang('Now you can track your time directly on projects using the Stopwatch');
  }
}
