<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Utils\PushNotification;

use User;
use UserDevice;
use UserDevices;

class PushNotificationManager implements PushNotificationManagerInterface
{
    public function findDevicesByUserId(int $id): array
    {
        $devices = UserDevices::findBySQL('SELECT * FROM user_devices WHERE user_id = ?', $id);

        return $devices ? $devices->toArray() : [];
    }

    public function findDeviceByUserIdAndUniqueKey(int $user_id, string $unique_key): ?UserDevice
    {
        /** @var UserDevice | null $device */
        $device = UserDevices::findOneBy([
            'user_id' => $user_id,
            'unique_key' => $unique_key,
        ]);

        return $device;
    }

    public function createDeviceForUser(User $user, $payload): UserDevice
    {
        $payload['user_id'] = $user->getId();
        /** @var UserDevice $device */
        $device = UserDevices::create($payload);

        return $device;
    }

    public function saveDevice(UserDevice $device): void
    {
        $device->save();
    }

    public function deleteDevice(UserDevice $device): void
    {
        $device->delete();
    }

    public function getUnreadNotificationsCountForUserId(int $id): int
    {
        return \DB::executeFirstCell("SELECT COUNT(DISTINCT n.parent_type, n.parent_id) AS 'row_count' FROM notifications AS n LEFT JOIN notification_recipients AS nr ON n.id = nr.notification_id WHERE nr.recipient_id = ? AND nr.read_on IS NULL", $id);
    }
}
