<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Utils\PushNotification;

use User;
use UserDevice;

interface PushNotificationManagerInterface
{
    /**
     * @return UserDevice[]
     */
    public function findDevicesByUserId(int $id): array;

    public function findDeviceByUserIdAndUniqueKey(int $user_id, string $unique_key): ?UserDevice;

    public function createDeviceForUser(User $user, $payload): UserDevice;

    public function saveDevice(UserDevice $device): void;

    public function deleteDevice(UserDevice $device): void;

    public function getUnreadNotificationsCountForUserId(int $id): int;
}
