<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Utils\PushNotification;

use User;

class PushNotificationService implements PushNotificationServiceInterface
{
    private PushNotificationManagerInterface $manager;

    private PushNotificationPayloadTransformerInterface $transformer;

    public function __construct(
        PushNotificationManagerInterface $manager,
        PushNotificationPayloadTransformerInterface $transformer
    )
    {
        $this->manager = $manager;
        $this->transformer = $transformer;
    }

    public function subscribe(User $user, $payload): void
    {
        $device = $this->manager->findDeviceByUserIdAndUniqueKey($user->getId(), $payload['unique_key']);
        if ($device && $device->getToken() !== $payload['token']){
            $device->setToken($payload['token']);
        }
        if (!$device){
            $device = $this->manager->createDeviceForUser($user, $payload);
        }
        $this->manager->saveDevice($device);
    }

    public function unsubscribe(User $user, string $unique_key): void
    {
        $device = $this->manager->findDeviceByUserIdAndUniqueKey($user->getId(), $unique_key);
        if ($device){
            $this->manager->deleteDevice($device);
        }
    }

    public function getManager(): PushNotificationManagerInterface
    {
        return $this->manager;
    }

    public function getPayload(\Notification $notification, \IUser $recipient): array
    {
        return $this->transformer->transform($notification, $recipient);
    }
}
