<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

namespace ActiveCollab\Module\System\Utils\PushNotification;

use User;

interface PushNotificationServiceInterface
{
    public function subscribe(User $user, $payload);

    public function unsubscribe(User $user, string $unique_key);

    public function getPayload(\Notification $notification, \IUser $recipient): array;

    public function getManager(): PushNotificationManagerInterface;
}
