<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

use Angie\Http\Request;
use Angie\Http\Response;
use Angie\Http\Response\StatusResponse\StatusResponse;

AngieApplication::useController('auth_required', EnvironmentFramework::INJECT_INTO);

class UserConversationsController extends AuthRequiredController
{
    protected ?ConversationUser $user_conversation = null;

    public function __before(Request $request, $user)
    {
        $before_result = parent::__before($request, $user);

        if ($before_result !== null) {
            return $before_result;
        }

        if ($user instanceof Client) {
            return Response::NOT_FOUND;
        }

        $conversation_id = $request->getId('conversation_id');

        if ($conversation_id) {
            $this->user_conversation = ConversationUsers::find([
                'conditions' => ['user_id = ? AND conversation_id = ?', $user->getId(), $conversation_id],
                'one' => true,
            ]);

            if (!$this->user_conversation) {
                return Response::NOT_FOUND;
            }
        }

        return null;
    }

    public function edit(Request $request, User $user)
    {
        try {
            return ConversationUsers::update($this->user_conversation, $request->put());
        } catch (ValidationErrors $e) {
            return new StatusResponse(
                Response::BAD_REQUEST,
                '',
                ['message' => $e->getErrorsAsString()]
            );
        }
    }
}
