<?php

/*
 * This file is part of the ActiveCollab project.
 *
 * (c) A51 doo <info@activecollab.com>. All rights reserved.
 */

declare(strict_types=1);

use ActiveCollab\ActiveCollabJwt\Factory\JwtFactoryInterface;
use ActiveCollab\ActiveCollabJwt\Factory\LcobucciJwtFactory;
use ActiveCollab\ActiveCollabJwt\Verifier\JwtVerifierInterface;
use ActiveCollab\ActiveCollabJwt\Verifier\LcobucciJwtVerifier;
use ActiveCollab\CurrentTimestamp\CurrentTimestampInterface;
use ActiveCollab\Foundation\App\RootUrl\RootUrlInterface;
use ActiveCollab\Foundation\Mail\Incoming\Processor\MailboxesSet\Resolver\DefaultSenderResolverInterface;
use ActiveCollab\Foundation\Mail\Incoming\Processor\MailboxesSet\Resolver\MailboxesSetResolver;
use ActiveCollab\Foundation\Mail\Incoming\Processor\MailboxesSet\Resolver\MailboxesSetResolverInterface;
use ActiveCollab\Foundation\Mail\Incoming\Processor\Processor;
use ActiveCollab\Foundation\Mail\Incoming\Processor\ProcessorInterface;
use ActiveCollab\Foundation\Text\BodyProcessor\TagProcessor\Links\TextReplacement\Resolver\TextReplacementResolverInterface;
use ActiveCollab\Foundation\Urls\Expander\UrlExpander;
use ActiveCollab\Foundation\Urls\Expander\UrlExpanderInterface;
use ActiveCollab\Foundation\Urls\Factory\UrlFactory;
use ActiveCollab\Foundation\Urls\IgnoredDomainsResolver\IgnoredDomainsResolverInterface;
use ActiveCollab\Foundation\Urls\Router\RouterInterface;
use ActiveCollab\Foundation\Wrappers\DataObjectPool\DataObjectPoolInterface;
use ActiveCollab\Module\OnDemand\services\account\OccupyAndActivateService;
use ActiveCollab\Module\OnDemand\Utils\OccupyAccountServiceResolver\OccupyAccountServiceResolver;
use ActiveCollab\Module\OnDemand\Utils\OccupyAccountServiceResolver\OccupyAccountServiceResolverInterface;
use ActiveCollab\Module\System\Utils\AuthorizeFileAccessService\AuthorizeFileAccessService;
use ActiveCollab\Module\System\Utils\AuthorizeFileAccessService\AuthorizeFileAccessServiceInterface;
use ActiveCollab\Module\System\Utils\BodyProcessorResolver\BodyProcessorResolver;
use ActiveCollab\Module\System\Utils\BodyProcessorResolver\BodyProcessorResolverInterface;
use ActiveCollab\Module\System\Utils\Conversations\ConversationFactory;
use ActiveCollab\Module\System\Utils\Conversations\ConversationFactoryInterface;
use ActiveCollab\Module\System\Utils\Conversations\ConversationResolver;
use ActiveCollab\Module\System\Utils\Conversations\ConversationResolverInterface;
use ActiveCollab\Module\System\Utils\DateValidationResolver\TaskDateValidationResolver;
use ActiveCollab\Module\System\Utils\Dependency\ProjectTemplateDependencyResolver;
use ActiveCollab\Module\System\Utils\Dependency\ProjectTemplateDependencyResolverInterface;
use ActiveCollab\Module\System\Utils\IncomingMail\Bouncer;
use ActiveCollab\Module\System\Utils\IncomingMail\MailToCommentMiddleware;
use ActiveCollab\Module\System\Utils\IncomingMail\MailToProjectMiddleware;
use ActiveCollab\Module\System\Utils\InlineImageDetailsResolver\InlineImageDetailsResolver;
use ActiveCollab\Module\System\Utils\InlineImageDetailsResolver\InlineImageDetailsResolverInterface;
use ActiveCollab\Module\System\Utils\JwtTokenIssuer\FileAccessIntentIssuer;
use ActiveCollab\Module\System\Utils\JwtTokenIssuer\JwtTokenIssuerInterface;
use ActiveCollab\Module\System\Utils\NotificationRecipientsCleaner\NotificationRecipientsCleaner;
use ActiveCollab\Module\System\Utils\NotificationRecipientsCleaner\NotificationRecipientsCleanerInterface;
use ActiveCollab\Module\System\Utils\ProjectTemplateDuplicator\ProjectTemplateDuplicator;
use ActiveCollab\Module\System\Utils\ProjectTemplateDuplicator\ProjectTemplateDuplicatorInterface;
use ActiveCollab\Module\System\Utils\ProjectToTemplateConverter\ProjectToTemplateConverter;
use ActiveCollab\Module\System\Utils\ProjectToTemplateConverter\ProjectToTemplateConverterInterface;
use ActiveCollab\Module\System\Utils\PushNotification\PushNotificationManager;
use ActiveCollab\Module\System\Utils\PushNotification\PushNotificationManagerInterface;
use ActiveCollab\Module\System\Utils\PushNotification\PushNotificationPayloadTransformer;
use ActiveCollab\Module\System\Utils\PushNotification\PushNotificationService;
use ActiveCollab\Module\System\Utils\PushNotification\PushNotificationServiceInterface;
use ActiveCollab\Module\System\Utils\Sockets\PusherSocket;
use ActiveCollab\Module\System\Utils\Sockets\PusherSocketInterface;
use ActiveCollab\Module\System\Utils\Storage\StorageOverusedNotifier\StorageOverusedNotifier;
use ActiveCollab\Module\System\Utils\Storage\StorageOverusedNotifier\StorageOverusedNotifierInterface;
use Angie\Authentication\RequestProcessor\ShepherdRequestProcessor;
use Angie\Mailer;
use Angie\Memories\MemoriesWrapperInterface;
use Angie\Notifications\NotificationsInterface;
use Angie\Storage\Capacity\StorageCapacityCalculatorInterface;
use Angie\Utils\OnDemandStatus\OnDemandStatusInterface;
use function DI\get;
use Psr\Container\ContainerInterface;
use Psr\Log\LoggerInterface;

return [
    // @TODO: Remove dependency on global DB class.
    UrlExpanderInterface::class => function (ContainerInterface $c) {
        return new UrlExpander(DB::getConnection(), $c->get(LoggerInterface::class));
    },
    InlineImageDetailsResolverInterface::class => get(InlineImageDetailsResolver::class),
    ProjectTemplateDuplicatorInterface::class => get(ProjectTemplateDuplicator::class),
    ProjectTemplateDependencyResolverInterface::class => function () {
        return new ProjectTemplateDependencyResolver(
            AngieApplication::authentication()->getAuthenticatedUser()
        );
    },

    // @TODO: Remove dependencies that AngieApplication provides.
    BodyProcessorResolverInterface::class => function (ContainerInterface $c) {
        return new BodyProcessorResolver(
            $c->get(DataObjectPoolInterface::class),
            AngieApplication::authentication(),
            $c->get(RouterInterface::class),
            $c->get(RouterInterface::class),
            $c->get(UrlExpanderInterface::class),
            $c->get(InlineImageDetailsResolverInterface::class),
            $c->get(TextReplacementResolverInterface::class),
            $c->get(IgnoredDomainsResolverInterface::class),
            $c->get(RootUrlInterface::class),
            AngieApplication::log()
        );
    },

    // @TODO: Remove dependencies that AngieApplication provides.
    StorageOverusedNotifierInterface::class => function (ContainerInterface $container) {
        return new StorageOverusedNotifier(
            $container->get(NotificationsInterface::class),
            $container->get(MemoriesWrapperInterface::class),
            AngieApplication::getContainer()->get(StorageCapacityCalculatorInterface::class),
            $container->get(CurrentTimestampInterface::class),
            $container->get(RootUrlInterface::class),
            AngieApplication::log()
        );
    },

    TaskDateValidationResolver::class => function () {
        return new TaskDateValidationResolver(
            DateValue::makeFromString('2000-01-01'),
            DateValue::now()->addDays(365 * 20)
        );
    },

    // @TODO: Remove dependencies on DB::getConnection().
    ProjectToTemplateConverterInterface::class => function () {
        return new ProjectToTemplateConverter(DB::getConnection());
    },
    'panoramix' => function (ContainerInterface $container) {
        return [
            'is_enabled' => $container->get(OnDemandStatusInterface::class)->isOnDemand() && AngieApplication::featureFlags()->isEnabled('panoramix_enabled'),
            'url' => defined('PANORAMIX_URL') ? PANORAMIX_URL : null,
        ];
    },

    NotificationRecipientsCleanerInterface::class => get(NotificationRecipientsCleaner::class),
    PushNotificationManagerInterface::class => function () {
        return new PushNotificationManager();
    },
    PushNotificationServiceInterface::class => function (ContainerInterface $container) {
        $transformer = new PushNotificationPayloadTransformer(AngieApplication::getAccountId());

        return new PushNotificationService($container->get(PushNotificationManagerInterface::class), $transformer);
    },
    JwtFactoryInterface::class => function () {
        return new LcobucciJwtFactory(
            ROOT_URL
        );
    },
    JwtTokenIssuerInterface::class => function ($c) {
        return new FileAccessIntentIssuer(
            $c->get(JwtFactoryInterface::class),
            defined('FILE_ACCESS_TOKEN_KEY') ? (string) FILE_ACCESS_TOKEN_KEY : (string) AngieApplication::getLicenseKey(),
            AngieApplication::isOnDemand() ? JwtTokenIssuerInterface::WH_AUDIENCE : ROOT_URL,
            new DateTimeImmutable(),
            AngieApplication::isOnDemand() ? AngieApplication::getAccountId() : null
        );
    },
    AuthorizeFileAccessServiceInterface::class => function (ContainerInterface $container) {
        return new AuthorizeFileAccessService(
            $container->get(JwtTokenIssuerInterface::class),
            new UrlFactory(
                $container->get(RouterInterface::class),
                $container->get(RootUrlInterface::class)
            )
        );
    },

    JwtVerifierInterface::class => function () {
        return new LcobucciJwtVerifier(
            AngieApplication::isOnDemand() ? ShepherdRequestProcessor::INTENT_AUDIENCE_ACTIVECOLLAB : ROOT_URL
        );
    },
    RealTimeUsersChannelsResolverInterface::class => function () {
        return new RealTimeUsersChannelsResolver(
            AngieApplication::authentication(),
            AngieApplication::featureFlags()
        );
    },
    PusherSocketInterface::class => function (ContainerInterface $container) {
        return new PusherSocket(
            AngieApplication::realTimeIntegrationResolver(),
            $container->get(RealTimeUsersChannelsResolverInterface::class),
            new PusherSocketPayloadTransformator(),
            new PusherSocketPayloadPartialTransformator(),
            AngieApplication::getAccountId()
        );
    },
    DefaultSenderResolverInterface::class => function () {
        return new class() implements DefaultSenderResolverInterface {
            public function getDefaultSender(): string
            {
                return Mailer::getDefaultSender()->getEmail();
            }
        };
    },
    MailboxesSetResolverInterface::class => get(MailboxesSetResolver::class),
    ProcessorInterface::class => function (ContainerInterface $container) {
        $data_object_pool = $container->get(DataObjectPoolInterface::class);
        $logger = $container->get(LoggerInterface::class);

        return new Processor(
            $container->get(MailboxesSetResolverInterface::class),
            new Bouncer(
                $container->get(NotificationsInterface::class),
                $logger
            ),
            $logger,
            new MailToProjectMiddleware(
                $data_object_pool,
                $logger
            ),
            new MailToCommentMiddleware(
                $data_object_pool,
                $logger
            )
        );
    },
    OccupyAccountServiceResolverInterface::class => function ($c) {
        return new OccupyAccountServiceResolver(
            AngieApplication::occupyAccountService(),
            new OccupyAndActivateService(
                AngieApplication::occupyAccountService(),
                AngieApplication::getAccountId(),
                AngieApplication::initialSettingsCacheInvalidator(),
                AngieApplication::shepherdAccountConfig(),
                AngieApplication::eventsDispatcher(),
                AngieApplication::billingDateCalculator(),
                AngieApplication::log(),
                AngieApplication::addOnFinder()
            )
        );
    },
    ConversationResolverInterface::class => function () {
        return new ConversationResolver();
    },
    ConversationFactoryInterface::class => function ($container) {
        return new ConversationFactory(
            $container->get(ConversationResolverInterface::class)
        );
    },
];
