<?php

declare(strict_types=1);

namespace ActiveCollab\ActiveCollabJobs\Jobs\Push;

use ActiveCollab\ActiveCollabJobs\Jobs\Job;
use ActiveCollab\ActiveCollabJobs\Utils\PushMessagingServiceInterface;
use Kreait\Firebase\Messaging\ApnsConfig;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

class PushNotificationJob extends Job
{
    public function execute()
    {
        if (
            $this->getContainer()->has(
                PushMessagingServiceInterface::class
            )) {
            $service = $this->getContainer()->get(PushMessagingServiceInterface::class);
            $job_data =  $this->getData();
            $device_tokens = $job_data['device_tokens'] ?? null;
            $title = $job_data['title'] ?? null;
            $body = $job_data['body'] ?? null;
            $data = $job_data['data'] ?? [];
            $badge = $job_data['badge'] ?? 0;

            if ($device_tokens && $title) {
                $message = CloudMessage::new();
                $notification = Notification::create($title, $body);
                $message = $message->withNotification($notification)
                    ->withData($data)
                    ->withDefaultSounds()
                    ->withApnsConfig(ApnsConfig::new()->withBadge($badge)->withDefaultSound());

                return $service->sendMulticast($message, $device_tokens);
            }
        }
        return false;
    }
}
