<?php
namespace QuickBooksOnline\API\Data;

/**
 * @xmlNamespace http://schema.intuit.com/finance/v3
 * @xmlType 
 * @xmlName IPPRecurringInfo
 * @var IPPRecurringInfo
 * @xmlDefinition 
				Description: Describes the Recurring Schedules for Transactions
			
 */
class IPPRecurringInfo
	{

		/**                                                                       
		* Initializes this object, optionally with pre-defined property values    
		*                                                                         
		* Initializes this object and it's property members, using the dictionary
		* of key/value pairs passed as an optional argument.                      
		*                                                                         
		* @param dictionary $keyValInitializers key/value pairs to be populated into object's properties 
		* @param boolean $verbose specifies whether object should echo warnings   
		*/                                                                        
		public function __construct($keyValInitializers=array(), $verbose=FALSE)
		{
			foreach($keyValInitializers as $initPropName => $initPropVal)
			{
				if (property_exists('IPPRecurringInfo',$initPropName) || property_exists('QuickBooksOnline\API\Data\IPPRecurringInfo',$initPropName))
				{
					$this->{$initPropName} = $initPropVal;
				}
				else
				{
					if ($verbose)
						echo "Property does not exist ($initPropName) in class (".get_class($this).")";
				}
			}
		}

	
	/**
	 * @Definition 
						Product: QBO
						Description: The name of the Recurring Schedule Template.
					
	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlName Name
	 * @var string
	 */
	public $Name;
	/**
	 * @Definition  
						Product: QBO
						Description: The Recur Type which can be Automated, Reminded, UnScheduled or Manual.
					
	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlName RecurType
	 * @var string
	 */
	public $RecurType;
	/**
	 * @Definition  
						Product: QBO
						Description: Indicates whether the Recurring Schedule is enabled.
					
	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlName Active
	 * @var boolean
	 */
	public $Active;
	/**
	 * @Definition 
						Product: QBO
						Description: The Scheduling Information.
					
	 * @xmlType element
	 * @xmlNamespace http://schema.intuit.com/finance/v3
	 * @xmlMinOccurs 0
	 * @xmlName ScheduleInfo
	 * @var com\intuit\schema\finance\v3\IPPRecurringScheduleInfo
	 */
	public $ScheduleInfo;


} // end class IPPRecurringInfo
